<!DOCTYPE html>
<html lang="en">

<?php include 'includes/header.php' ?>

<style>
    /* General */
    body {
        background-color: #121212;
        color: #e0e0e0;
        font-family: 'Poppins', sans-serif;
    }

    a {
        text-decoration: none;
    }

    h1, h2, h3, h4, h5, h6 {
        color: #ffffff;
    }

    /* Carousel */
    .carousel-text {
        color: #ff6b35;
        font-weight: 700;
        text-shadow: 0px 0px 10px rgba(255, 107, 53, 0.8);
        transition: transform 0.3s ease-in-out, text-shadow 0.3s ease-in-out;
    }

    .header-carousel .owl-carousel-item {
        position: relative;
    }

    .header-carousel .overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        display: flex;
        align-items: center;
    }

    .header-carousel h5 {
        color: #ff6b35;
        letter-spacing: 2px;
        font-weight: 500;
    }

    .header-carousel a.btn {
        border-radius: 50px;
        font-weight: 600;
        transition: 0.3s;
    }

    .header-carousel a.btn:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.4);
    }

    /* Cards & Services */
    .service-item {
        background: #1e1e1e;
        border-radius: 12px;
        padding: 25px 15px;
        transition: 0.3s;
    }

    .service-item:hover {
        transform: translateY(-10px);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.3);
    }

    .service-item i {
        color: #ff6b35;
    }

    /* About Section */
    .about-img img {
        border-radius: 12px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.5);
    }

    .about-text p {
        color: #d0d0d0;
    }

    /* Gallery */
    .gallery-img {
        border-radius: 12px;
        object-fit: cover;
        height: 250px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .gallery-img:hover {
        transform: scale(1.05);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.5);
    }

    /* Courses */
    .course-item {
        background: #1e1e1e;
        border-radius: 12px;
        overflow: hidden;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .course-item:hover {
        transform: translateY(-10px);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.3);
    }

    .course-item img {
        transition: transform 0.3s ease;
    }

    .course-item:hover img {
        transform: scale(1.1);
    }

    .course-item a.btn {
        border-radius: 50px;
        background: linear-gradient(45deg, #ff6b35, #ff3f3f);
        border: none;
        color: #fff;
        font-weight: 600;
        transition: 0.3s;
    }

    .course-item a.btn:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.4);
    }

    /* Locations / Team */
    .location-item {
        background: #1e1e1e;
        border-radius: 12px;
        padding: 30px 15px;
        text-align: center;
        transition: 0.3s;
    }

    .location-item:hover {
        transform: translateY(-10px);
        box-shadow: 0 10px 20px rgba(255, 107, 53, 0.3);
    }

    .location-item i {
        color: #ff3f3f;
        margin-bottom: 15px;
    }

    /* Testimonial */
    .testimonial-item {
        background: #1e1e1e;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.5);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .testimonial-item:hover {
        transform: translateY(-10px);
        box-shadow: 0 15px 25px rgba(255, 107, 53, 0.4);
    }

    .testimonial-item img {
        border: 3px solid #ff6b35;
    }

    .testimonial-text {
        color: #d0d0d0;
        font-style: italic;
        margin-top: 10px;
    }

    /* Buttons & Back-to-top */
    .back-to-top {
        background: linear-gradient(45deg, #ff6b35, #ff3f3f) !important;
    }

    .back-to-top:hover {
        background: linear-gradient(45deg, #ff3f3f, #ff6b35) !important;
    }
</style>

<body>
    <?php include 'includes/topnav.php' ?>

    <!-- Carousel Start -->
    <div class="container-fluid p-0 mb-5">
        <div class="owl-carousel header-carousel">
            <div class="owl-carousel-item">
                <img class="img-fluid w-100" src="img/carousel-1.jpg" alt="">
                <div class="overlay">
                    <div class="container">
                        <div class="row justify-content-start">
                            <div class="col-sm-10 col-lg-8">
                                <h5 class="animated slideInDown">Best English Class</h5>
                                <h1 class="display-3 carousel-text animated slideInDown">Welcome to AVEnglishAcademy</h1>
                                <a href="" class="btn btn-primary py-3 px-5 me-3 animated slideInLeft">Read More</a>
                                <a href="admin/login.php" class="btn btn-light py-3 px-5 animated slideInRight">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="owl-carousel-item">
                <img class="img-fluid w-100" src="img/carousel-2.jpg" alt="">
                <div class="overlay">
                    <div class="container">
                        <div class="row justify-content-start">
                            <div class="col-sm-10 col-lg-8">
                                <h5 class="animated slideInDown">Best English Class</h5>
                                <h1 class="display-3 carousel-text animated slideInDown">The Best English Learning Platform</h1>
                                <a href="" class="btn btn-primary py-3 px-5 me-3 animated slideInLeft">Read More</a>
                                <a href="admin/login.php" class="btn btn-light py-3 px-5 animated slideInRight">Join Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Carousel End -->

    <!-- Services Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-3 col-sm-6">
                    <div class="service-item">
                        <i class="fa-solid fa-3x fa-graduation-cap mb-4"></i>
                        <h5>Skilled Instructor</h5>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="service-item">
                        <i class="fa fa-3x fa-globe mb-4"></i>
                        <h5>Online Classes</h5>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="service-item">
                        <i class="fa fa-3x fa-home mb-4"></i>
                        <h5>Hall Classes</h5>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="service-item">
                        <i class="fa-solid fa-3x fa-user-group mb-4"></i>
                        <h5>Group Classes</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Services End -->

    <!-- About Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="row g-5 align-items-center">
                <div class="col-lg-6 about-img">
                    <img src="img/teacher/main.jpg" class="img-fluid" alt="">
                </div>
                <div class="col-lg-6 about-text">
                    <h6 class="text-primary">About Me</h6>
                    <h1>Avantha Bambaradeniya</h1>
                    <p>As an English Language Lecturer with over 5 years of experience, I am committed to nurturing language proficiency and empowering students to reach their full potential. Join me in the journey of mastering the English language.</p>
                    <p><i class="fa fa-arrow-right text-primary me-2"></i>Skilled Instructor</p>
                    <p><i class="fa fa-arrow-right text-primary me-2"></i>Certified</p>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->

    <!-- Gallery Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h6 class="text-primary">Portfolio</h6>
                <h1>Our Gallery</h1>
            </div>
            <div class="row g-3">
                <?php for ($i = 1; $i <= 8; $i++): ?>
                <div class="col-lg-3 col-md-6">
                    <a href="">
                        <img src="img/gallery/<?= $i ?>.jpg" class="gallery-img w-100" alt="">
                    </a>
                </div>
                <?php endfor; ?>
            </div>
        </div>
    </div>
    <!-- Gallery End -->

    <!-- Courses Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h6 class="text-primary">Classes</h6>
                <h1>Grades</h1>
            </div>
            <div class="row g-4 justify-content-center">
                <?php 
                $grades = [6,7,8,9,10,11];
                foreach($grades as $grade): ?>
                <div class="col-lg-4 col-md-6">
                    <div class="course-item">
                        <img src="img/grades/<?= $grade ?>.jpg" class="img-fluid" alt="">
                        <div class="text-center p-4">
                            <h3>Grade <?= $grade ?></h3>
                            <a href="admin/login.php" class="btn btn-primary mt-3">Join Now</a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- Courses End -->

    <!-- Locations Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h6 class="text-primary">Classes</h6>
                <h1>Locations</h1>
            </div>
            <div class="row g-4">
                <?php $locations = ["Hemmathagama","Mawanella","Kegalle","Gampola"]; 
                foreach($locations as $loc): ?>
                <div class="col-lg-3 col-sm-6">
                    <div class="location-item">
                        <i class="fa-solid fa-3x fa-location-dot mb-3"></i>
                        <h5><?= $loc ?></h5>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- Locations End -->

    <!-- Testimonial Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h6 class="text-primary">Testimonial</h6>
                <h1>Our Students Say!</h1>
            </div>
            <div class="owl-carousel testimonial-carousel">
                <?php for($i=1;$i<=4;$i++): ?>
                <div class="testimonial-item text-center">
                    <img src="img/testimonial-<?= $i ?>.jpg" class="rounded-circle mx-auto mb-3" style="width:80px;height:80px;">
                    <h5>Client Name</h5>
                    <p>Profession</p>
                    <p class="testimonial-text">"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore."</p>
                </div>
                <?php endfor; ?>
            </div>
        </div>
    </div>
    <!-- Testimonial End -->

    <!-- Footer -->
    <?php include 'includes/footer.php' ?>

    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>

    <?php include 'includes/js.php' ?>
</body>
</html>
